/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.IModifiableElementsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComplexIndex
implements IElementsIndex {
    private Map<IBuildPath, IModifiableElementsIndex> indexes = new HashMap<IBuildPath, IModifiableElementsIndex>();

    public synchronized IElementEntry addEntry(int category, String entryPath, Object value, IModule module, Object indexResource) {
        IModifiableElementsIndex index = this.indexes.get(indexResource);
        if (index != null) {
            return index.addEntry(category, entryPath, value, module);
        }
        return null;
    }

    public synchronized void removeModuleEntries(IModule module, Object indexResource) {
        IModifiableElementsIndex index = this.indexes.get(indexResource);
        if (index != null) {
            index.removeModuleEntries(module);
        }
    }

    @Override
    public synchronized List<IElementEntry> getEntries(int category, String path) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IModifiableElementsIndex index : this.indexes.values()) {
            result.addAll(index.getEntries(category, path));
        }
        return result;
    }

    @Override
    public synchronized List<IElementEntry> getEntriesStartingWith(int category, String path) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IModifiableElementsIndex index : this.indexes.values()) {
            result.addAll(index.getEntriesStartingWith(category, path));
        }
        return result;
    }

    @Override
    public synchronized List<IElementEntry> getModuleEntries(IModule module) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        for (IModifiableElementsIndex index : this.indexes.values()) {
            result.addAll(index.getModuleEntries(module));
        }
        return result;
    }

    @Override
    public synchronized Set<IModule> getModules() {
        HashSet<IModule> result = new HashSet<IModule>();
        for (IModifiableElementsIndex index : this.indexes.values()) {
            result.addAll(index.getModules());
        }
        return result;
    }

    public synchronized void addIndex(IBuildPath indexResource, IModifiableElementsIndex index) {
        this.indexes.put(indexResource, index);
    }

    public synchronized void removeIndex(IBuildPath indexResource) {
        this.indexes.remove(indexResource);
    }

    public Collection<IBuildPath> getPaths() {
        return this.indexes.keySet();
    }

    public IModifiableElementsIndex getElementIndex(IBuildPath p) {
        return this.indexes.get(p);
    }
}

